if ("serviceWorker" in navigator) {
  navigator.serviceWorker
    .register("/sw.js",{})
    .then((registration) => {
      console.info("🚀 service worker registered")
      // 检查更新
      registration.addEventListener("updatefound", () => {
        const installingWorker = registration.installing
        installingWorker.addEventListener("statechange", () => {
          if (installingWorker.state === "installed") {
            if (navigator.serviceWorker.controller) {
              // 强制刷新
              window.location.reload(true)
            }
          }
        })
      })
    })
    .catch((err) => console.error("service worker not registered", err))
}
