window.chrome.storage.sync.get(["OVO_JUMP_WORK_PAGE"], (result) => {
  console.warn("OVO_JUMP_WORK_PAGE", result.OVO_JUMP_WORK_PAGE)

  if (result.OVO_JUMP_WORK_PAGE) {
    const jumpWorkPage = (event) => {
      // 精确匹配Shift+W组合键（不包含其他修饰键）
      if (
        event.key.toLowerCase() === "w" &&
        event.shiftKey &&
        !event.ctrlKey &&
        !event.altKey &&
        !event.metaKey
      ) {
        event.preventDefault()
        removeEventListener("keydown", jumpWorkPage)
        // 页面跳转逻辑
        let targetURL = result.OVO_JUMP_WORK_PAGE
        // 如果开头不拼接协议 则自动拼接上https://
        if (
          !targetURL.startsWith("https://") &&
          !targetURL.startsWith("http://")
        ) {
          targetURL = "https://" + targetURL
        }
        window.location.href = targetURL
      }
    }
    document.addEventListener("keydown", jumpWorkPage)
  }
})
